#ifndef PALDECODE_H
#define PALDECODE_H

#include "ccrypt.h"

class PalColorDecoder : public VirtualDecoder
{
	public:
   		PalColorDecoder()
		{
 			_description = "PAL Color";
			_outwidth = 360;
			_outheight = 280;
			_use_vbi = true;
			_color_mode = true;
		}

   		void decodeFrame(unsigned char *membase, int offset, bool invert_polarity);

		virtual int convertRawXToScreenX(int x) const
			{ return((x-getColorBurstWidth())/5); }
		virtual int convertScreenXToRawX(int x) const
			{ return(x*5+getColorBurstWidth()); }


		virtual void processKey(WPARAM key);
		virtual const char* getHelp(void) const;
      
	protected:
   		bool _color_mode;
};


class PalGrayDecoder : public PalColorDecoder
{
	public:
		PalGrayDecoder()
      {
 			_description = "PAL Gris";
			_color_mode = false;
      }
};

#endif
